Time domain capacitance meter circuit
***************************************************************************
.TRAN  0.01ns  '2*dt'  SWEEP  CapV  LIN  'Points+1'  CapV1  CapV2
.OPTIONS POST=0 POST_VERSION=9007 ACCURATE RMAX=0.5 NUMDGT=8
.LIB 'Process.lib' Typ
***************************************************************************
.PARAM  Vin     = 0.0V
.PARAM  Ven     = 0.0V
***************************************************************************
.PARAM  CapV1   =   0.0V
.PARAM  CapV2   =   5.0V
.PARAM  Points  =  20
.PARAM  dt      =  10.0ns
***************************************************************************
.PARAM  dV      =   'CapV2-CapV1'
.PARAM  Ovh     =   0.1
.PARAM  CapV    =   0.0V
***************************************************************************
.MEAS  TRAN  Sw_I1  FIND  PAR('I(Vsw)')  WHEN  V(Sweep)=CapV  Rise=1
.MEAS  TRAN  Sw_I2  FIND  PAR('I(Vsw)')  WHEN  V(Sweep)=CapV  Fall=1
.MEAS  TRAN  CAP    PARAM='abs((Sw_I1-Sw_I2)/2*(dt/(dV+2*dV*Ovh)))'
***************************************************************************
Vvcc  Vcc    0  DC= 5.0
Vin   In     0  DC= Vin
Ven   En     0  DC= Ven
*
Vsw   Sweep  0  PWL
+  0ns        'CapV1-dV*Ovh'
+  dt         'CapV2+dV*Ovh'
+ '2*dt'      'CapV1-dV*Ovh'
***************************************************************************
X1  In  Sweep  Vcc  Vcc  0  0  En  IO_buf
*
*C1     Sweep   0    C=10.0pF               $ Test capacitor (constant)
*C1     Sweep   0    C='10.0e-12*V(sweep)'  $ Test capacitor (variable)
***************************************************************************
.alter
.PARAM  Vin = 5.0V
.PARAM  Ven = 0.0V
*
.alter
.PARAM  Vin = 0.0V
.PARAM  Ven = 5.0V
*
.alter
.PARAM  Vin = 5.0V
.PARAM  Ven = 5.0V
***************************************************************************
.END
